////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define WIN32_LEAN_AND_MEAN

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <ShlOBJ.H>
#include <PrSht.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <TChar.H>

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "NSWFL/System.H"
#include "NSWFL/Registry.H"
#include "NSWFL/Windows.H"

#include "Resources/Resource.H"

#include "Headers/Definitions.H"
#include "Headers/ClientUpdate.H"
#include "Headers/Functions.H"

#include "Dialogs/Main.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
    MainInstance = hInstance;

    INITCOMMONCONTROLSEX CommCtl;
    CommCtl.dwSize = sizeof(CommCtl);
    CommCtl.dwICC = ICC_PROGRESS_CLASS;
    InitCommonControlsEx(&CommCtl);

    if(!GetRegistryValues())
    {
        MessageBox(NULL, "Error getting registry values.", TitleCaption, 0);
        return 0;
    }

    if(strlen(szCmdLine) == 0)
    {
        MessageBox(NULL, "No HTTP URL was given.", TitleCaption, 0);
        RestartClientService();
        return 0;
    }

    if(strlen(szCmdLine) > 1024)
    {
        MessageBox(NULL, "An invalid HTTP URL was given.", TitleCaption, 0);
        RestartClientService();
        return 0;
    }

    strcpy(gsHttpURL, szCmdLine);

    DialogBox(MainInstance, MAKEINTRESOURCE(IDD_MAIN), 0, MainDialog);

    return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

